/* 
 *  UpdateCustomerPhoneRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.api.PhoneListEntryI;

public class UpdateCustomerPhoneRequest extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(UpdateCustomerPhoneRequest.class);
    private final PhoneListEntryI phoneEntry;

    public UpdateCustomerPhoneRequest(String interactionID, PhoneListEntryI phoneEntry) {
        super(LOG, interactionID);
        this.phoneEntry = phoneEntry;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getInteraction().updateCustomerPhone(phoneEntry);
        LOG.trace(methodName + "-");
        return null;
    }
}
